<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBMods - HelpDesk v1.55
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'helpdesk');
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('posting', 'search');

// get special data templates from the datastore
$specialtemplates = array('bbcodecache');

// pre-cache templates used by all actions
$globaltemplates = array(
	'HELPDESK_SHELL',
	'HELPDESK',
	'helpdesk_ticket',
	'helpdesk_ticketlist',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'newticket' => array(
		'helpdesk_newticket',
	),
	'mytickets' => array(
		'helpdesk_message',
	),
	'newreplies' => array(
		'helpdesk_message',
	),
	'ticket' => array(
		'helpdesk_quickreply',
		'helpdesk_reply',
	),
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_newpost.php');
require_once('./includes/functions_editor.php');
require_once('./includes/functions_bigthree.php');

// #######################################################################
// ######################## START FUNCTIONS ############################
// #######################################################################

// usergroup ticket permissions
// this is in here rather than init.php to prevent file edits
$_BITFIELD['usergroup']['ticketpermissions'] = array(
	'can_create_ticket'           => 1,
	'can_edit_ticket'         => 2,
	'can_delete_ticket'           => 4,
	'can_resolve_ticket'         => 8,
	'can_unresolve_ticket'       => 16,
	'can_claim_ownership'       => 32,
	'can_unclaim_ownership'       => 64,
	'can_edit_any_ticket'         => 128,
	'can_delete_any_ticket'           => 256,
	'can_resolve_any_ticket'         => 512,
	'can_unresolve_any_ticket'       => 1024
);

function construct_helpdesk_nav($selectedcell = 'usercp', $option = 0)
{
	global $navclass, $session;

	$cells = array(
	// department //
	'departments',
	'usergroup',
	// adminstrative //
	'unresolvedtickets',
	'resolvedtickets',
	'mytickets',
	'newtickets',
	'newreplies',
	// user //
	'newticket',
	'unresolved',
	'resolved'
	);

	// set the class for each cell/group
	$navclass = array();
	foreach ($cells AS $cellname)
	{
		$navclass["$cellname"] = 'alt2';
	}
	$navclass["$selectedcell"] = 'alt1';
}

function check_department_access($usergroupidlist)
{
	global $bbuserinfo;

	$groups = split(',', $usergroupidlist);
	foreach ($groups as $group => $g)
	{
		if (is_member_of($bbuserinfo, trim($g)))
			return true;
	}

	return false;
}

function check_administer_access()
{
	global $bbuserinfo, $DB_site, $departmentlist;

	$departments = $DB_site->query("SELECT usergroups, departmentid FROM " . TABLE_PREFIX . "ticketdepartment ORDER BY displayorder");
	while ($department = $DB_site->fetch_array($departments))
	{
		$groups = split(',', $department['usergroups']);
		foreach ($groups as $group => $g)
		{
			if (is_member_of($bbuserinfo, trim($g)))
			{
				$departmentlist[] = $department['departmentid'];
				$memberof[] = $g;
			}
		}
	}

	return $memberof;
}

function sendprivatemessage ($userinfo, $message, $subject)
{
	global $DB_site, $vbphrase;

	$userarray["$userinfo[userid]"] = $userinfo['username'];
	$serializedinfo = serialize($userarray);

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "pmtext (fromuserid, fromusername, title, message, touserarray, iconid, dateline, showsignature, allowsmilie) values ('1', '" . addslashes($vbphrase['helpdesk']) . "', '" . addslashes($subject) . "', '" . addslashes($message) ."', '".addslashes($serializedinfo)."', '4', '" . TIMENOW ."', '1', '1')");
	$pmid = $DB_site->insert_id();
	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "pm (pmtextid, userid) values (" . $pmid . ", '" . $userinfo['userid'] . "')");
	$DB_site->shutdown_query("UPDATE ".TABLE_PREFIX."user SET pmtotal = pmtotal + 1, pmunread = pmunread + 1, pmpopup = " . $userinfo['pmpopup'] . " WHERE userid = '" . $userinfo['userid'] . "'");
}

// #######################################################################
// ######################## END FUNCTIONS ############################
// #######################################################################


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ################### HELPDESK SWITCHED ON? ######################
if ($vboptions['helpdesk_switch'] == 0)
{
	eval(print_standard_error($vboptions['helpdesk_off_message'], 0));
}

// ################### USERGROUP ACCESS ######################
$departmentaccess = check_department_access($vboptions['helpdesk_department_access']);
$departmentlist = array();
$administeraccess = check_administer_access();

// ################### NO GUESTS ALLOWED WITH THIS VERSION ######################
if (!$bbuserinfo['userid'])
{
	print_no_permission();
}

// ################### GET CURRENT USER'S PERMISSIONS ######################
$usergroup = $usergroupcache[$bbuserinfo['usergroupid']];
$userpermissions = convert_bits_to_array($usergroup['ticketpermissions'], $_BITFIELD['usergroup']['ticketpermissions']);

// ################### START DOs ######################
if (empty($_REQUEST['do']))
{
	// if ($bbuserinfo[permissions][adminpermissions] > 0) Version 1.01
	if (is_array($administeraccess))
		$_REQUEST['do'] = 'mytickets';
	else
		$_REQUEST['do'] = 'unresolved';
}

// #######################################################################
// ######################## USERGROUP OPERATIONS ############################
// #######################################################################
if ($_REQUEST['do'] == 'saveusergroup')
{
	if ($departmentaccess != 1)
	{
		print_no_permission();
	}

	// check for usergroupid
	if (empty($_REQUEST['usergroupid']))
	{
		$idname = $vbphrase['usergroup'];
		eval(print_standard_error('error_noid'));
	}

	// check for unregistered - next version again
	if ($_REQUEST['usergroupid'] == 1)
	{
		eval(print_standard_error($vbphrase['no_guest_in_version'], 0));
	}

	// get usergroup's ticket permissions
	$usergroup = $usergroupcache[$_REQUEST['usergroupid']];

	// take array and make into bits
	require_once('./includes/functions_misc.php');
	$bits = convert_array_to_bits($_POST, $_BITFIELD['usergroup']['ticketpermissions'], 1);

	// let's update the database
	$DB_site->query("UPDATE " . TABLE_PREFIX . "usergroup SET ticketpermissions = '" . intval($bits) . "' WHERE usergroupid = '" . intval($_REQUEST['usergroupid']) . "'");

	// rebuild the cache
	require_once('./includes/adminfunctions.php');
	build_forum_permissions();

	// display all departments now
	$url = "helpdesk.php?$session[sessionurl]do=usergroup";
	eval(print_standard_redirect('redirect_postthanks'));
}

if ($_REQUEST['do'] == 'usergroup')
{
	if ($departmentaccess != 1)
	{
		print_no_permission();
	}

	// usergroups
	foreach ($usergroupcache AS $usergroup)
	{
		// this will prevent editing of the guest usergroup for now
		// this will be implemented in version 1.3
		if ($usergroup['usergroupid'] != 1)
		{
			exec_switch_bg();
			eval('$usergroups .= "' . fetch_template('helpdesk_usergroup') . '";');
		}
	}

	eval('$HTML = "' . fetch_template('helpdesk_usergrouplist') . '";');
}

if ($_REQUEST['do'] == 'updateusergroup')
{
	if ($departmentaccess != 1)
	{
		print_no_permission();
	}

	// check for usergroupid
	if (empty($_REQUEST['usergroupid']))
	{
		$idname = $vbphrase['usergroup'];
		eval(print_standard_error('error_noid'));
	}

	// check for unregistered - next version again
	if ($_REQUEST['usergroupid'] == 1)
	{
		eval(print_standard_error($vbphrase['no_guest_in_version'], 0));
	}

	// get usergroup's ticket permissions
	$usergroup = $usergroupcache[$_REQUEST['usergroupid']];

	// extract info
	$bitfieldinfo = convert_bits_to_array($usergroup['ticketpermissions'], $_BITFIELD['usergroup']['ticketpermissions']);
	foreach ($bitfieldinfo AS $perm => $usergroupvalue)
	{
		exec_switch_bg();
		$checked = '';
		$profilefieldname = $perm;
		if ($usergroupvalue == 1) $checked = HTML_CHECKED;
		$key = 1;
		$val = $vbphrase['yes'];
		eval('$radioselect = "' . fetch_template('userfield_radio_option') . '";');
		$checked = '';
		if ($usergroupvalue == 0) $checked = HTML_CHECKED;
		$key = 0;
		$val = $vbphrase['no'];
		eval('$radioselect .= "' . fetch_template('userfield_radio_option') . '";');
		eval('$perms .= "' . fetch_template('helpdesk_usergroupradio') . '";');
	}

	eval('$HTML = "' . fetch_template('helpdesk_usergroupsettings') . '";');
	// a sneaky fix for the navigation on left to be still correct color
	$_REQUEST['do'] = 'usergroup';
}

// #######################################################################
// ######################## DEPARTMENT OPERATIONS ############################
// #######################################################################
if ($_REQUEST['do'] == 'adddepartment')
{
	if ($departmentaccess != 1)
	{
		print_no_permission();
	}

	// strip white space
	$usergroups = implode(array_map('trim', split(',', $_REQUEST['usergroups'])), ',');
	
	// add department
	$DB_site->query(
		"INSERT INTO " . TABLE_PREFIX . "ticketdepartment(
			department, displayorder, usergroups
		) VALUES (
			'" . addslashes($_REQUEST['department']) . "',
			" . intval($_REQUEST['displayorder']) . ",
			'" . addslashes($usergroups) . "'
		)");

	// set message so you know it was added
	$message = $vbphrase['department_added'];

	// display all departments now
	$url = "helpdesk.php?$session[sessionurl]do=departments";
	eval(print_standard_redirect('redirect_postthanks'));
}

if ($_REQUEST['do'] == 'updatedepartment')
{
	if ($departmentaccess != 1)
	{
		print_no_permission();
	}

	// check for departmentid
	if (empty($_REQUEST['departmentid']))
	{
		$idname = $vbphrase['department'];
		eval(print_standard_error('error_noid'));
	}

	if (isset($_REQUEST['delete']))
	{
		// check for last department
		$first = $DB_site->query_first("SELECT departmentid FROM " . TABLE_PREFIX . "ticketdepartment WHERE departmentid != '" . intval($_REQUEST['departmentid']) . "' ORDER BY displayorder");
		if (empty($first))
		{
			eval(print_standard_error($vbphrase['cannot_delete_last_department'], 0));
		}

		// move tickets to the first department that would be displayed
		$DB_site->query("UPDATE " . TABLE_PREFIX . "ticket SET departmentid = '" . intval($first['departmentid']) . "', ownerid = 0 WHERE departmentid = '" . intval($_REQUEST['departmentid']) . "'");

		// delete
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "ticketdepartment WHERE departmentid = ".$_REQUEST['departmentid']);
		$message = $vbphrase['department_deleted'];
	}
	else
	{
		// strip white space
		$usergroups = implode(array_map('trim', split(',', $_REQUEST['usergroups'])), ',');
	
		// add department
		$DB_site->query(
			"UPDATE " . TABLE_PREFIX . "ticketdepartment SET
				department = '" . addslashes($_REQUEST['department']) . "', 
				displayorder = " . intval($_REQUEST['displayorder']) . ", 
				usergroups = '" . addslashes($usergroups) . "'
			WHERE
				departmentid = " . intval($_REQUEST['departmentid'])
		);

		$message = $vbphrase['department_updated'];
	}

	// display all departments now
	$url = "helpdesk.php?$session[sessionurl]do=departments";
	eval(print_standard_redirect('redirect_postthanks'));
}

if ($_REQUEST['do'] == 'departments')
{
	if ($departmentaccess != 1)
	{
		print_no_permission();
	}

	// get departments
	$departmentquery = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "ticketdepartment ORDER BY displayorder");
	while ($department = $DB_site->fetch_array($departmentquery))
	{
		exec_switch_bg();
		eval('$departments .= "' . fetch_template('helpdesk_department') . '";');
	}
	
	eval('$HTML = "' . fetch_template('helpdesk_departmentlist') . '";');
}

// #######################################################################
// ######################## TICKET OPERATIONS ############################
// #######################################################################
if ($_REQUEST['do'] == 'ticketreply')
{
	if (empty($_REQUEST['tid']))
	{
		$idname = $vbphrase['ticket'];
		eval(print_standard_error('error_noid'));
	}

	globalize($_POST, array('WYSIWYG_HTML', 'message' => STR));
	if (isset($WYSIWYG_HTML))
	{
		require_once('./includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($WYSIWYG_HTML, $vboptions['allowhtml']);
	}
	else
	{
		$message = trim($message);
	}

	$DB_site->query(
		"INSERT INTO " . TABLE_PREFIX . "ticketreply(
			ticketid, username, userid, dateline, pagetext, ipaddress
		) VALUES (
			" . intval($_REQUEST['tid']) . ",
			'" . addslashes($bbuserinfo['username']) . "',
			" . intval($bbuserinfo[userid]) . ",
			" . TIMENOW . ",
			'" . addslashes($message) . "',
			'" . addslashes(IPADDRESS) . "'
		)");

	$DB_site->query("UPDATE " . TABLE_PREFIX ."ticket SET lastposter = '" . addslashes($bbuserinfo['username']) . "', lastupdate = " . TIMENOW . " WHERE ticketid = ".$_REQUEST['tid']);
	
	$url = "helpdesk.php?$session[sessionurl]do=ticket&tid=".$_REQUEST['tid'];
	eval(print_standard_redirect('redirect_postthanks'));
}


// ############################### ticket tools ###############################
if ($_REQUEST['do'] == 'claim' || $_REQUEST['do'] == 'unclaim')
{
	if (!is_array($administeraccess))
	{
		print_no_permission();
	}

	if (empty($_REQUEST['tid']))
	{
		$idname = $vbphrase['ticket'];
		eval(print_standard_error('error_noid'));
	}

	// pull ticket info to check permissions
	$ticketinfo = $DB_site->query_first("SELECT ownerid FROM " . TABLE_PREFIX ."ticket WHERE ticketid = '" . intval($_REQUEST['tid']) . "'");

	if ($_REQUEST['do'] == 'claim')
	{
		// check for permission to claim an unclaimed ticket
		if ($ticketinfo['ownerid'] != 0 && $userpermissions['can_claim_ticket'] != 1) print_no_permission();
		$ticketmessage = $vbphrase['claimed_ownership'];
		$ownerid = $bbuserinfo['userid'];
	}
	else
	{
		// check for permission to unclaim your claimed ticket
		if ($ticketinfo['ownerid'] != $bbuserinfo['userid'] && $userpermissions['can_unclaim_ticket'] != 1) print_no_permission();
		$ticketmessage = $vbphrase['unclaimed_ownership'];
		$ownerid = 0;
	}

	$DB_site->query("UPDATE " . TABLE_PREFIX ."ticket SET ownerid = ".$ownerid." WHERE ticketid = " . $_REQUEST['tid']);

	$_REQUEST['do'] = 'ticket';
}

if ($_REQUEST['do'] == 'resolveticket' || $_REQUEST['do'] == 'unresolveticket')
{
	if (empty($_REQUEST['tid']))
	{
		$idname = $vbphrase['ticket'];
		eval(print_standard_error('error_noid'));
	}

	$ticket = $DB_site->query_first("SELECT postuserid, open FROM " . TABLE_PREFIX ."ticket WHERE ticketid = " . $_REQUEST['tid']);

	if ($_REQUEST['do'] == 'resolveticket')
	{
		if (($ticket['open'] != 1 || $bbuserinfo['userid'] != $ticket['postuserid'] && $userpermissions['can_resolve_ticket'] != 1) || ($userpermissions['can_resolve_any_ticket'] != 1 || $ticket['open'] != 1)) print_no_permission();
		$ticketmessage = $vbphrase['ticket_resolved'];
		$open = 0;
	}
	else
	{
		if (($ticket['open'] != 0 || $bbuserinfo['userid'] != $ticket['postuserid'] && $userpermissions['can_unresolve_ticket'] != 1) || ($userpermissions['can_unresolve_any_ticket'] != 1 || $ticket['open'] != 0)) print_no_permission();
		$ticketmessage = $vbphrase['ticket_unresolved'];
		$open = 1;
	}

	$DB_site->query("UPDATE " . TABLE_PREFIX ."ticket SET open = ".$open." WHERE ticketid = " . $_REQUEST['tid']);

	$_REQUEST['do'] = 'ticket';
}

if ($_REQUEST['do'] == 'delete')
{
	if (empty($_REQUEST['tid']))
	{
		$idname = $vbphrase['ticket'];
		eval(print_standard_error('error_noid'));
	}

	$creator = $DB_site->query_first("SELECT postuserid, open FROM " . TABLE_PREFIX ."ticket WHERE ticketid = " . $_REQUEST['tid']);
	if (($bbuserinfo['userid'] != $creator['postuserid'] || $userpermissions['can_delete_ticket'] != 1) && $userpermissions['can_delete_any_ticket'] != 1) print_no_permission();

	// insert into deleted tickets table
	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "ticketdeleted SELECT * FROM " . TABLE_PREFIX . "ticket WHERE ticketid = " . intval($_REQUEST['tid']));

	// delete ticket
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "ticket WHERE ticketid = " . intval($_REQUEST['tid']));

	$url = "helpdesk.php?$session[sessionurl]";
	eval(print_standard_redirect($vbphrase['ticket_deleted'], 0));
}

if ($_REQUEST['do'] == 'editreply')
{
	if (empty($_REQUEST['rid']))
	{
		$idname = $vbphrase['reply'];
		eval(print_standard_error('error_noid'));
	}

	$reply = $DB_site->query_first("SELECT ticketid, userid FROM " . TABLE_PREFIX ."ticketreply WHERE replyid = " . $_REQUEST['rid']);
	if (($bbuserinfo['userid'] != $reply['userid'] || $userpermissions['can_edit_ticket'] != 1) && $userpermissions['can_edit_any_ticket'] != 1) print_no_permission();

	globalize($_POST, array('WYSIWYG_HTML', 'message' => STR));
	if (isset($WYSIWYG_HTML))
	{
		require_once('./includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($WYSIWYG_HTML, $vboptions['allowhtml']);
	}
	else
	{
		$message = trim($message);
	}

	$DB_site->query("UPDATE " . TABLE_PREFIX . "ticketreply SET pagetext = '" . addslashes($message) . "' WHERE replyid = '" . intval($_REQUEST['rid']) . "'");

	$DB_site->query("UPDATE " . TABLE_PREFIX ."ticket SET departmentid = '" . addslashes($_REQUEST['departmentid']) . "', title = '" . addslashes($_REQUEST['title']) . "' WHERE ticketid = ".$reply['ticketid']);
	
	$url = "helpdesk.php?$session[sessionurl]do=ticket&tid=".$reply['ticketid'];
	eval(print_standard_redirect('redirect_postthanks'));
}

if ($_REQUEST['do'] == 'edit')
{
	if (empty($_REQUEST['rid']))
	{
		$idname = $vbphrase['reply'];
		eval(print_standard_error('error_noid'));
	}

	$reply = $DB_site->query_first("
		SELECT ticketreply.*, departmentid, title FROM 
		" . TABLE_PREFIX ."ticketreply AS ticketreply
		LEFT JOIN " . TABLE_PREFIX ."ticket AS ticket ON (ticketreply.ticketid = ticket.ticketid)
		WHERE replyid = " . $_REQUEST['rid']);
	if (($bbuserinfo['userid'] != $reply['userid'] || $userpermissions['can_edit_ticket'] != 1) && $userpermissions['can_edit_any_ticket'] != 1) print_no_permission();

	// pull departments
	$departments = $DB_site->query("SELECT department, departmentid FROM " . TABLE_PREFIX . "ticketdepartment ORDER BY displayorder");
	while ($department = $DB_site->fetch_array($departments))
	{
		$selected = '';
		$key = $department['departmentid'];
		$val = $department['department'];
		if ($key == $reply['departmentid']) $selected = HTML_SELECTED;
		eval('$departmentselect .= "' . fetch_template('userfield_select_option') . '";');
	}

	$vbphrase[ticket] = ucfirst($vbphrase[ticket]);
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];
	construct_edit_toolbar($reply['pagetext'], 0, 'privatemessage');
	eval('$HTML = "' . fetch_template('helpdesk_replyedit') . '";');
}

// #######################################################################
// ######################## NEW TICKET OPERATIONS ############################
// #######################################################################
if ($_REQUEST['do'] == 'newticket')
{
	if ($vboptions['helpdesk_new_tickets'] != 1 || $userpermissions['can_create_ticket'] != 1)
	{
		eval(print_standard_error($vboptions['helpdesk_tickets_message'], 0));
	}

	// pull departments
	$departments = $DB_site->query("SELECT department, departmentid FROM " . TABLE_PREFIX . "ticketdepartment ORDER BY displayorder");
	while ($department = $DB_site->fetch_array($departments))
	{
		$key = $department['departmentid'];
		$val = $department['department'];
		eval('$departmentselect .= "' . fetch_template('userfield_select_option') . '";');
	}

	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];
	construct_edit_toolbar('', 0, 'privatemessage');
	eval('$HTML = "' . fetch_template('helpdesk_newticket') . '";');
}

if ($_REQUEST['do'] == 'submitnewticket')
{
	globalize($_POST, array('WYSIWYG_HTML', 'message' => STR));
	if (isset($WYSIWYG_HTML))
	{
		require_once('./includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($WYSIWYG_HTML, $vboptions['allowhtml']);
	}
	else
	{
		$message = trim($message);
	}

	$DB_site->query(
		"INSERT INTO " . TABLE_PREFIX ."ticket(
			title, departmentid, postusername, postuserid, lastposter, lastupdate, dateline
		) VALUES (
			'" . addslashes(htmlspecialchars_uni($_REQUEST['title'])) . "',
			'" . intval($_REQUEST['departmentid']) . "',
			'" . addslashes($bbuserinfo['username']) . "',
			'" . intval($bbuserinfo['userid']) . "',
			'" . addslashes($bbuserinfo['username']) . "',
			" . TIMENOW . ",
			" . TIMENOW . "
		)");
	$ticketid = $DB_site->insert_id();
	$DB_site->query(
		"INSERT INTO " . TABLE_PREFIX . "ticketreply(
			ticketid, username, userid, dateline, pagetext, ipaddress
		) VALUES (
			" . intval($ticketid) . ",
			'" . addslashes($bbuserinfo['username']) . "',
			" . intval($bbuserinfo[userid]) . ",
			" . TIMENOW . ",
			'" . addslashes($message) . "',
			'" . addslashes(IPADDRESS) . "'
		)");

	if ($vboptions['helpdesk_auto_repsonse'] == 1)
	{ // send PM to user
		if ($bbuserinfo['permissions']['pmquota'] != 0)
		{
			$toemail = $bbuserinfo['email'];
			eval(fetch_email_phrases('helpdesk_auto_response', iif(isset($newpost_lang["$toemail"]), $newpost_lang["$toemail"], 0)));
			sendprivatemessage ($bbuserinfo, $message, $subject);
		}
		else
		{
			// lets send an email instead
			$vboptions['helpdesk_auto_repsonse'] = 2;
		}
	}
	// not doing an else if here in case user doesn't have PM permissions
	// if they don't have them, then we're going to send them an email instead.
	if ($vboptions['helpdesk_auto_repsonse'] == 2)
	{ // send email to user
		// check that admins can send users emails
		if ($bbuserinfo['adminemail'] == 1)
		{
			$toemail = $bbuserinfo['email'];
			eval(fetch_email_phrases('helpdesk_auto_response', iif(isset($newpost_lang["$toemail"]), $newpost_lang["$toemail"], 0)));
			vbmail($toemail, $subject, $message, true);
		}
	}


	$url = "helpdesk.php?$session[sessionurl]do=ticket&tid=".$ticketid;
	eval(print_standard_redirect('redirect_postthanks'));
}

// #######################################################################
// ######################## LISTING TICKETS OPERAIONS ############################
// #######################################################################
if ($_REQUEST['do'] == 'unresolved' || $_REQUEST['do'] == 'resolved')
{
	$headertitle = $vbphrase[$_REQUEST['do'].'_tickets'];
	if ($_REQUEST['do'] == 'unresolved')
	{
		$ticketquery = $DB_site->query("SELECT ticketid, title, postusername, dateline, lastposter, lastupdate, department FROM " . TABLE_PREFIX . "ticket AS ticket LEFT JOIN " . TABLE_PREFIX . "ticketdepartment AS ticketdepartment ON (ticketdepartment.departmentid = ticket.departmentid) WHERE open = 1 AND postuserid = ".$bbuserinfo['userid']);
		$noticketmessage = $vbphrase['no_unresolved'];
	}
	else
	{
		$ticketquery = $DB_site->query("SELECT ticketid, title, postusername, dateline, lastposter, lastupdate, department FROM " . TABLE_PREFIX . "ticket AS ticket LEFT JOIN " . TABLE_PREFIX . "ticketdepartment AS ticketdepartment ON (ticketdepartment.departmentid = ticket.departmentid) WHERE open = 0 AND postuserid = ".$bbuserinfo['userid']);
		$noticketmessage = $vbphrase['no_resolved'];
	}
	while ($ticket = $DB_site->fetch_array($ticketquery))
	{
		exec_switch_bg();
		$ticket['dateline'] = vbdate($vboptions['dateformat'], $ticket['dateline'], true);
		$ticket['lastupdate'] = vbdate($vboptions['dateformat'], $ticket['lastupdate'], true);
		eval('$tickets .= "' . fetch_template('helpdesk_ticket') . '";');
	}
	if (empty($tickets))
	{
		exec_switch_bg();
		$message = $noticketmessage;
		eval('$tickets .= "' . fetch_template('helpdesk_message') . '";');
	}
	eval('$HTML = "' . fetch_template('helpdesk_ticketlist') . '";');
}

// ############################### administrative ticket list ###############################
if ($_REQUEST['do'] == 'newtickets' || $_REQUEST['do'] == 'newreplies' || $_REQUEST['do'] == 'mytickets' || $_REQUEST['do'] == 'unresolvedtickets' || $_REQUEST['do'] == 'resolvedtickets')
{
	if (!is_array($administeraccess))
	{
		print_no_permission();
	}

	if ($_REQUEST['do'] == 'newtickets')
	{
		$headertitle = $vbphrase['new_tickets'];
		$ticketquery = $DB_site->query("SELECT ticketid, title, postusername, dateline, lastposter, lastupdate, department FROM " . TABLE_PREFIX . "ticket AS ticket LEFT JOIN " . TABLE_PREFIX . "ticketdepartment AS ticketdepartment ON (ticketdepartment.departmentid = ticket.departmentid) WHERE open = 1 AND ownerid = 0 AND dateline >= ".$bbuserinfo['lastvisit']." AND ticketdepartment.departmentid IN (" . implode($departmentlist, ',') . ")");
		$noticketmessage = $vbphrase['no_new_tickets'];
	}
	else if ($_REQUEST['do'] == 'newreplies')
	{
		$headertitle = $vbphrase['new_replies'];
		$ticketquery = $DB_site->query("SELECT ticketid, title, postusername, dateline, lastposter, lastupdate, department FROM " . TABLE_PREFIX . "ticket AS ticket LEFT JOIN " . TABLE_PREFIX . "ticketdepartment AS ticketdepartment ON (ticketdepartment.departmentid = ticket.departmentid) WHERE open = 1 AND (ownerid = 0 OR ownerid = '" . intval($bbuserinfo['userid']) . "') AND dateline != lastupdate AND lastposter != '" . addslashes($bbuserinfo['username']) . "' AND lastupdate >= ".$bbuserinfo['lastvisit']." AND ticketdepartment.departmentid IN (" . implode($departmentlist, ',') . ")");
		$noticketmessage = $vbphrase['no_new_replies'];
	}
	else if ($_REQUEST['do'] == 'mytickets')
	{
		$headertitle = $vbphrase['my_tickets'];
		$ticketquery = $DB_site->query("SELECT ticketid, title, postusername, dateline, lastposter, lastupdate, department FROM " . TABLE_PREFIX . "ticket AS ticket LEFT JOIN " . TABLE_PREFIX . "ticketdepartment AS ticketdepartment ON (ticketdepartment.departmentid = ticket.departmentid) WHERE open = 1 AND ownerid = ".$bbuserinfo['userid']. " AND ticketdepartment.departmentid IN (" . implode($departmentlist, ',') . ")");
		$noticketmessage = $vbphrase['no_tickets_claimed_unresolved'];
	}
	else if ($_REQUEST['do'] == 'resolvedtickets')
	{
		$headertitle = $vbphrase['resolved_tickets'];
		$ticketquery = $DB_site->query("SELECT ticketid, title, postusername, dateline, lastposter, lastupdate, department FROM " . TABLE_PREFIX . "ticket AS ticket LEFT JOIN " . TABLE_PREFIX . "ticketdepartment AS ticketdepartment ON (ticketdepartment.departmentid = ticket.departmentid) WHERE open = 0 AND ticketdepartment.departmentid IN (" . implode($departmentlist, ',') . ")");
		$noticketmessage = $vbphrase['no_tickets_claimed_unresolved'];
	}
	else
	{
		$headertitle = $vbphrase['unresolved_tickets'];
		$ticketquery = $DB_site->query("SELECT ticketid, title, postusername, dateline, lastposter, lastupdate, department FROM " . TABLE_PREFIX . "ticket AS ticket LEFT JOIN " . TABLE_PREFIX . "ticketdepartment AS ticketdepartment ON (ticketdepartment.departmentid = ticket.departmentid) WHERE open = 1 AND ownerid = 0 AND ticketdepartment.departmentid IN (" . implode($departmentlist, ',') . ")");
		$noticketmessage = $vbphrase['no_tickets_unresolved'];
	}
	while ($ticket = $DB_site->fetch_array($ticketquery))
	{
		exec_switch_bg();
		$ticket['dateline'] = vbdate($vboptions['dateformat'], $ticket['dateline'], true);
		$ticket['lastupdate'] = vbdate($vboptions['dateformat'], $ticket['lastupdate'], true);
		eval('$tickets .= "' . fetch_template('helpdesk_ticket') . '";');
	}
	if (empty($tickets))
	{
		exec_switch_bg();
		$message = $noticketmessage;
		eval('$tickets .= "' . fetch_template('helpdesk_message') . '";');
	}
	eval('$HTML = "' . fetch_template('helpdesk_ticketlist') . '";');
}

if ($_REQUEST['do'] == 'search')
{
	eval('$HTML = "' . fetch_template('helpdesk_search') . '";');
}
// ############################### show ticket ###############################
if ($_REQUEST['do'] == 'ticket')
{
	if (empty($_REQUEST['tid']))
	{
		$idname = $vbphrase['ticket'];
		eval(print_standard_error('error_noid'));
	}

	$repliesquery = $DB_site->query("SELECT tr.*, title, ownerid, open FROM " . TABLE_PREFIX ."ticketreply AS tr, " . TABLE_PREFIX ."ticket AS t WHERE tr.ticketid = '" . addslashes($_REQUEST['tid']) . "' AND tr.ticketid = t.ticketid ORDER BY replyid ASC");
	if ($DB_site->num_rows($repliesquery) == 0)
	{
		$idname = $vbphrase['ticket'];
		eval(print_standard_error('error_invalidid'));
	}

	require_once('./includes/functions_bbcodeparse.php');

	while ($reply = $DB_site->fetch_array($repliesquery))
	{
		exec_switch_bg();
		$reply['dateline'] = vbdate($vboptions['dateformat'], $reply['dateline'], true);
		$reply['pagetext'] = parse_bbcode($reply['pagetext'], 'nonforum', $vboptions['allowsmilies']);
		eval('$HTML .= "' . fetch_template('helpdesk_reply') . '";');
	}
	$htmlcodeon = iif($vboptions['allowhtml'], $vbphrase['on'], $vbphrase['off']);
	$bbcodeon = iif($vboptions['allowbbcode'], $vbphrase['on'], $vbphrase['off']);
	$imgcodeon = iif($vboptions['allowbbimagecode'], $vbphrase['on'], $vbphrase['off']);
	$smilieson = iif($vboptions['allowsmilies'], $vbphrase['on'], $vbphrase['off']);
	$stylevar['messagewidth'] = $stylevar['messagewidth_usercp'];
	construct_edit_toolbar('', 0, 'privatemessage', 0);
	eval('$HTML .= "' . fetch_template('helpdesk_quickreply') . '";');
}

// draw cp nav bar
construct_helpdesk_nav($_REQUEST['do']);

// build navbar
$navbits = construct_navbits(array('' => $vbphrase['helpdesk']));
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('print_output("' . fetch_template('HELPDESK_SHELL') . '");');

?>